import {
    View,
    Text,
    ScrollView,
    TextInput,
    TouchableOpacity,
    RefreshControl,
    StyleSheet,
} from 'react-native';
import React, { useRef } from 'react';
import { ProfileStyles } from '../../../ProfileStyle';
import BackNavigation from '../../../../Utilities/CustomHeader/BackNavigation';
import { OrderDetailsStyle } from '../../../OrderHistory/OrderDetails/OrderDetailsStyle';
import DotIcon from '../../../../../assets/svgs/order details/dot.svg';
import { MyRefundStyle } from '../../MyRefundStyle';
import dpr from '../../../../Utilities/CustomStyleAttribute/dpr';

import { useDispatch, useSelector } from 'react-redux';
import { useEffect } from 'react';
import { useState } from 'react';
import useAuth from '../../../../../hooks/useAuth';
import { postRefundMessage } from '../../../../../redux/slices/user/myRefund/refundMessage/PostRefundMessage';

import RefundDetailsSkeleton from '../../../../../src/skeletons/screens/profile/refund/RefundDetailsSkeleton';
import {
    dynamicStatusBG,
    dynamicStatusDot,
    dynamicStatusText,
    refundDetailsStyle,
} from './refundDetailsStyle';
import RenderMessage from './RenderMessage';
import RenderImage from './RenderImage';
import CustomSpinner from '../../../../Utilities/CustomSpinner/CustomSpinner';
import {
    getRefundDetails,
    getRefundDetailsSuccess,
    getRefundMessage,
    pendingRefundMessage,
} from '../../../../../redux/slices/user/myRefund/refundMessage/getRefundDetails';
import ProgressiveImage from '../../../../../src/components/ProgressiveImage';
import { refundStyle } from '../../RefundRequest/RefundRequestStyle';
import { BASE_API_URL_STG } from '@env';
import { getMyRefunds } from '../../../../../redux/slices/user/myRefund/getMyRefunds';
import { queryResponse } from '../../../../../redux/slices/util/processResponse';
import useLangTranslation from '../../../../../hooks/useLangTranslation';
import CustomSVG from '../../../../../src/components/CustomSVG/CustomSVG';
import { I18nManager } from 'react-native';

const RefundDetails = (props) => {
    const { trans } = useLangTranslation();
    const { timeZone, refundId } = props?.route?.params;
    const URL = `${BASE_API_URL_STG}/user/refunds/${refundId}`;
    const refundMessageUrl = `${BASE_API_URL_STG}/user/refunds/${refundId}/messages`;
    const refundUrl = `${BASE_API_URL_STG}/user/refunds`;

    const scrollViewRef = useRef();
    const dispatch = useDispatch();
    const { loading } = useSelector((state) => state.postRefundMessage);
    const [inFileLoading, setInFileLoading] = useState(true);
    const {
        refundDetails: refund,
        messages: chat,
        loading: isLoading,
        isRefresh,
    } = useSelector((state) => state.myRefundDetails);
    const [messageError, setMessageError] = useState(false);
    const [text, setText] = useState('');
    const { access_token } = useAuth();

    useEffect(() => {
        let isMounted = true;
        if (isMounted) {
            
            dispatch(getRefundDetails({ access_token, URL }));
            access_token && setInFileLoading(false);
        }
        return () => {
            isMounted = false;
        };
    }, [refundId]);

    useEffect(() => {
        let isMounted = true;
        let intervalId;
        if (isMounted) {
            intervalId = setInterval(() => {
                dispatch(
                    getRefundMessage({ access_token, URL: refundMessageUrl })
                );
            }, 2000);
        }
        return () => {
            clearInterval(intervalId);
            isMounted = false;
        };
    }, [refundMessageUrl, access_token]);
    
    const {
        reference,
        quantity_sent,
        reason,
        refund_image_urls,
        product_image_url,
        line_items,
        status,
    } = refund || {};

    const handleMessage = async (text) => {
        if (text) {
            setMessageError(false);
            let formData = new FormData();
            formData.append('note', text);
            let data = {
                access_token,
                urlPost: refundMessageUrl,
                method: 'POST',
                formData,
            };
            try {
                let newAdd = await dispatch(postRefundMessage(data));
                let { code } = newAdd?.payload?.status;
                let { message } = newAdd?.payload?.records;
                if (code === 200) {
                    setText('');
                    await dispatch(
                        getRefundMessage({
                            access_token,
                            URL: refundMessageUrl,
                        })
                    );
                    if (chat?.data?.length == 0) {
                        dispatch(
                            getMyRefunds({ access_token, URL: refundUrl })
                        );
                        const response = await queryResponse(
                            URL,
                            'GET',
                            access_token
                        );
                        dispatch(getRefundDetailsSuccess(response));
                    }
                } else {
                }
            } catch (error) {}
        } else {
            setMessageError(true);
        }
    };
    const handleReverse = (array) => {
        let reverseArray = [...array].reverse();
        return reverseArray;
    };
    const handleRefresh = async () => {
        try {
            dispatch(pendingRefundMessage());
            const response = await queryResponse(URL, 'GET', access_token);
            dispatch(getRefundDetailsSuccess(response));
        } catch (error) {}
    };

    const styles = Styles(messageError, status);

    return (
        <>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans('refund details')}
                capitalize={true}
            />
            <View style={ProfileStyles.hrLine} />
            <View style={refundStyle.wrap}>
                {isLoading || inFileLoading ? (
                    <RefundDetailsSkeleton />
                ) : (
                    <ScrollView
                        keyboardShouldPersistTaps='always'
                        nestedScrollEnabled
                        showsVerticalScrollIndicator={false}
                        style={refundStyle.container}
                        refreshControl={
                            <RefreshControl
                                refreshing={isRefresh}
                                onRefresh={handleRefresh}
                            />
                        }
                    >
                        <View style={refundDetailsStyle.detailHeader}>
                            <View>
                                <Text style={refundDetailsStyle.REFERENCE}>
                                    {trans('REFERENCE')}
                                </Text>
                                <Text style={OrderDetailsStyle.invoiceId}>
                                    {reference}
                                </Text>
                            </View>
                            <View>
                                <Text style={refundDetailsStyle.statusText}>
                                    {trans('Status')}
                                </Text>
                                <View style={OrderDetailsStyle.statusCont}>
                                    <View style={[OrderDetailsStyle.status, styles.bgStatus]} >
                                        <CustomSVG svgIcon={DotIcon}
                                            fill={dynamicStatusDot(status)}
                                        />
                                        <Text style={[OrderDetailsStyle.statusText, styles.textStatus]}>
                                            {status}
                                        </Text>
                                    </View>
                                </View>
                            </View>
                        </View>
                        <View style={[MyRefundStyle.lastRefund, styles.lastRefund]}>
                            <View>
                                <Text style={MyRefundStyle.title}>
                                    {trans('Product Details')}
                                </Text>
                                <Text style={MyRefundStyle.text1}>
                                    {line_items?.category}
                                </Text>
                                <Text style={MyRefundStyle.text2}>
                                    {`${line_items?.name}`.length > 25
                                        ? `${line_items?.name}`.slice(0, 25) +
                                          ` . . .`
                                        : `${line_items?.name}`}
                                </Text>
                                <View style={MyRefundStyle.variations}>
                                    {line_items?.variations &&
                                        Object.entries(
                                            line_items.variations
                                        ).map((v, i) => {
                                            return (
                                                <View
                                                    key={i}
                                                    style={
                                                        MyRefundStyle.variationsItem
                                                    }
                                                >
                                                    <Text
                                                        style={
                                                            MyRefundStyle.attribute
                                                        }
                                                    >
                                                        {v[0]}: {v[1]}
                                                    </Text>
                                                    <View
                                                        style={MyRefundStyle.hr}
                                                    />
                                                </View>
                                            );
                                        })}
                                    <Text style={MyRefundStyle.attribute}>
                                        Qty: {quantity_sent}
                                    </Text>
                                </View>
                            </View>
                            <View>
                                <View style={refundDetailsStyle.imgCont}>
                                    <ProgressiveImage
                                        source={{ uri: product_image_url }}
                                        style={refundDetailsStyle.img}
                                    />
                                </View>
                            </View>
                        </View>
                        <View style={refundDetailsStyle.reason}>
                            <Text style={refundDetailsStyle.reasonTextTitle}>
                                {trans('Refund Reason')}:
                            </Text>
                            <Text style={refundDetailsStyle.reasonText}>
                                {trans(reason)}
                            </Text>
                        </View>
                        {refund_image_urls?.length > 0 && (
                            <View>
                                <Text style={[refundDetailsStyle.reasonText, styles.reasonText]}>
                                    {trans('Uploaded Pictures')}:
                                </Text>
                                <View style={refundDetailsStyle.uploadCont}>
                                    <ScrollView
                                        showsHorizontalScrollIndicator={false}
                                        nestedScrollEnabled={true}
                                        horizontal={true}
                                    >
                                        {refund_image_urls?.map(
                                            (item, index) => (
                                                <RenderImage
                                                    item={item}
                                                    key={index}
                                                    data={refund_image_urls}
                                                    index={index}
                                                />
                                            )
                                        )}
                                    </ScrollView>
                                </View>
                            </View>
                        )}
                        {chat?.data?.length > 0 && (
                            <View>
                                <Text style={refundDetailsStyle.yourMessage}>
                                    {trans('Your Messages')}
                                </Text>
                                <View style={refundDetailsStyle.showMessage}>
                                    <ScrollView
                                        showsVerticalScrollIndicator={false}
                                        nestedScrollEnabled={true}
                                        ref={scrollViewRef}
                                        onContentSizeChange={() =>
                                            scrollViewRef.current.scrollToEnd({
                                                animated: true,
                                            })
                                        }
                                    >
                                        {handleReverse(chat?.data).map(
                                            (item, index) => (
                                                <RenderMessage
                                                    item={item}
                                                    key={index}
                                                    timeZone={timeZone}
                                                />
                                            )
                                        )}
                                    </ScrollView>
                                </View>
                            </View>
                        )}
                        {!(status === 'Declined' || status === 'Accepted') && (
                            <View style={refundDetailsStyle.flex1}>
                                <Text style={refundDetailsStyle.writeMessageText}>
                                    {trans('Write A Message')}
                                </Text>
                                <TextInput
                                    style={[refundDetailsStyle.textArea, styles.messageInput]}
                                    multiline={true}
                                    numberOfLines={4}
                                    value={text}
                                    onChangeText={(e) => setText(e)}
                                    placeholder={trans('Enter your message here')}
                                />
                                <TouchableOpacity
                                    style={refundDetailsStyle.sendMessage}
                                    disabled={loading ? true : false}
                                    onPress={() => handleMessage(text)}
                                >
                                    {loading ? (
                                        <CustomSpinner
                                            filePath={require('../../../../../assets/lottie/loader2.json')}
                                            size={{
                                                width: dpr(60),
                                                height: dpr(50),
                                            }}
                                        />
                                    ) : (
                                        <Text
                                            style={
                                                refundDetailsStyle.sendMessageText
                                            }
                                        >
                                            {trans('Send Message')}
                                        </Text>
                                    )}
                                </TouchableOpacity>
                            </View>
                        )}
                    </ScrollView>
                )}
            </View>
        </>
    );
};

export default RefundDetails;

const Styles = (messageError, status) => StyleSheet.create({
    messageInput: {
        borderColor: messageError ? '#E43147' : '#DFDFDF',
    },
    bgStatus: {
        backgroundColor: dynamicStatusBG(status),
    },
    textStatus: {
        color: dynamicStatusText(status)
    },
    lastRefund: {
        alignItems: 'center'
    },
    reasonText: {
        marginTop: dpr(15)
    }
});
